/******************************************************************************
 * %Id: icc_bridge_if.h,v 1.2 2008/12/10 04:36:56 taiyo Exp $
 *
 * FileName		:icc_bridge_if.h
 *
 * Description	:for Bridge(wrapper) I/F Define header
 *
 *
 * Copyright	:Panasonic Corporation.
 *
 *****************************************************************************/
#ifndef	_ICC_BRIDGE_IF_H_
#define	_ICC_BRIDGE_IF_H_

#include <linux/iosc/icc_bridge_data.h>

/* for API */
#define ICC_IOC_SETCALLBACK     IOSC_DEFINE_RWCMD(L_ICC_MAGIC,  1 , sizeof(struct icc_status_arg_t))
#define ICC_IOC_CLEARCALLBACK   IOSC_DEFINE_RWCMD(L_ICC_MAGIC,  2 , sizeof(struct icc_arg_t))
#define ICC_IOC_GETSTATUS       IOSC_DEFINE_RWCMD(L_ICC_MAGIC,  3 , sizeof(struct icc_status_arg_t))
#define ICC_IOC_SETCLOCKRATE    IOSC_DEFINE_RWCMD(L_ICC_MAGIC,  4 , sizeof(struct icc_clockrate_arg_t))
#define ICC_IOC_GETCLOCKRATE    IOSC_DEFINE_RWCMD(L_ICC_MAGIC,  5 , sizeof(struct icc_clockrate_arg_t))
#define ICC_IOC_INITPARAMS      IOSC_DEFINE_RWCMD(L_ICC_MAGIC,  6 , sizeof(struct icc_arg_t))
#define ICC_IOC_SETPARAMS       IOSC_DEFINE_RWCMD(L_ICC_MAGIC,  7 , sizeof(struct icc_setparams_arg_t))
#define ICC_IOC_UNSETPARAMS     IOSC_DEFINE_RWCMD(L_ICC_MAGIC,  8 , sizeof(struct icc_arg_t))
#define ICC_IOC_RESETCARD       IOSC_DEFINE_RWCMD(L_ICC_MAGIC,  9 , sizeof(struct icc_resetcard_arg_t))
#define ICC_IOC_IOSEQUENCE      IOSC_DEFINE_RWCMD(L_ICC_MAGIC, 10 , sizeof(struct icc_iosequence_arg_t))
#define ICC_IOC_IORESYNCH       IOSC_DEFINE_RWCMD(L_ICC_MAGIC, 11 , sizeof(struct icc_arg_t))
#define ICC_IOC_SETCARDSTATUS   IOSC_DEFINE_RWCMD(L_ICC_MAGIC, 12 , sizeof(struct icc_status_arg_t))
#define ICC_IOC_SETCLOCKSRC     IOSC_DEFINE_RWCMD(L_ICC_MAGIC, 13 , sizeof(struct icc_clocksrc_arg_t))

/* for Callback */
#define CB_ICC_IRQ_INSERTED     IOSC_DEFINE_NODATACMD(L_ICC_MAGIC, 1)
#define CB_ICC_IRQ_REMOVED      IOSC_DEFINE_NODATACMD(L_ICC_MAGIC, 2)
#define CB_ICC_IRQ_VCCERR       IOSC_DEFINE_NODATACMD(L_ICC_MAGIC, 3)


#endif	/* _ICC_BRIDGE_IF_H_ */

/* end of icc_bridge_if.h */
